/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.PluginService;
import de.willuhn.jameica.services.ProxyService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ClassFinder;
import de.willuhn.util.I18N;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransportService
implements Bootable {
    private Map<String, Class<? extends Transport>> map = null;

    public Class<Bootable>[] depends() {
        return new Class[]{ProxyService.class, PluginService.class, BeanService.class};
    }

    public void init(BootLoader arg0, Bootable arg1) throws SkipServiceException {
        if (this.map != null) {
            return;
        }
        Logger.info((String)"init transport service");
        this.map = new HashMap<String, Class<? extends Transport>>();
        try {
            Class[] classes;
            ClassFinder finder = Application.getClassLoader().getClassFinder();
            for (Class c : classes = finder.findImplementors(Transport.class)) {
                try {
                    Transport t = (Transport)c.newInstance();
                    Logger.info((String)("  " + c.getName()));
                    List<String> protocols = t.getProtocols();
                    if (protocols == null || protocols.size() == 0) {
                        Logger.warn((String)"  supports no protocols, skipping");
                        continue;
                    }
                    for (String p : protocols) {
                        if (p == null) continue;
                        p = p.toLowerCase();
                        Logger.info((String)("    " + p));
                        this.map.put(p, t.getClass());
                    }
                }
                catch (Throwable t) {
                    Logger.error((String)("unable to load " + c + ", skipping"), (Throwable)t);
                }
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error((String)"no transport implementations found", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.map != null) {
            this.map.clear();
        }
    }

    public Transport getTransport(URL url) throws ApplicationException {
        I18N i18n = Application.getI18n();
        if (url == null) {
            throw new ApplicationException(i18n.tr("Keine URL angegeben"));
        }
        String p = url.getProtocol().toLowerCase();
        Class<? extends Transport> c = this.map.get(p);
        if (c == null) {
            throw new ApplicationException(i18n.tr("Protokoll \"{0}\" wird nicht unterst\u00fctzt", p));
        }
        try {
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            Transport t = service.get(c);
            t.init(url);
            return t;
        }
        catch (Exception e) {
            Logger.error((String)("unable to load class " + c), (Throwable)e);
            throw new ApplicationException(i18n.tr("Protokoll-Implementierung {0} konnte nicht geladen werden: {1}", new String[]{p, e.getMessage()}));
        }
    }
}

